#include "../mdk/mdk.h"
#include <windows.h>
#include "resource.h"
#include "songinfobase.h"

#pragma optimize ("awy", on) 

CMachineParameter const *pParameters[] = { NULL };
CMachineAttribute const *pAttributes[] = { NULL };

#pragma pack(1)		

#pragma pack()


CMachineInfo const MacInfo = 
{
	MT_EFFECT,
	MI_VERSION,	
	MIF_DOES_INPUT_MIXING|MIF_NO_OUTPUT,
	0,										// min tracks
	0,										// max tracks
	0,										// numGlobalParameters
	0,										// numTrackParameters
	pParameters,
	0,
	pAttributes,
	"SuperDonut SongInf",								// name
	"SongInf",								// short name
	"Edward L. Blake",						// author
	"&Song.Inf..."
};

class mi;

HINSTANCE dllInstance;
mi *g_mi;

class csinf : public CSongInfoHandler {
public:
	virtual void OpenSIDialog();
	virtual char * GetSongInfoName() { return "SuperDonut SongInf"; }
	virtual void GetTags(int tag_id, char *tagdata);
public:
	mi *pmi;
};

class miex : public CMDKMachineInterfaceEx { };

class mi : public CMDKMachineInterface
{
public:
	mi();
	virtual ~mi();
	virtual void Tick();
	virtual void MDKInit(CMachineDataInput * const pi);
	virtual bool MDKWork(float *psamples, int numsamples, int const mode);
	virtual bool MDKWorkStereo(float *psamples, int numsamples, int const mode);
	virtual void Command(int const i);
	virtual void MDKSave(CMachineDataOutput * const po);
	virtual char const *DescribeValue(int const param, int const value);

	virtual bool mi::OnDoubleClick(void *);
public:
	virtual CMDKMachineInterfaceEx *GetEx() { return &ex; }
	virtual void OutputModeChanged(bool stereo) {}

public:
	miex ex;
	csinf csex; 
	HWND buzzwindow;
public:
	char song_title[255];
	char song_author[255];
	char song_album[255];
	char song_url[255];
	char song_genre[255];
	char song_other[255];
	char song_description[4096];

	CMachine *ThisMachine;
};


mi::mi() { }
mi::~mi() {
	OEBSongInfo_Unload();
}


BOOL APIENTRY SongInfoStDialog(HWND hDlg, UINT uMsg, WPARAM wParam, LPARAM lParam);

void mi::MDKInit(CMachineDataInput * const pi)
{
	char junkie[100];int junkie2;
	SetOutputMode( true );	//	If true, the MDKWork will never be called, meaning that Buzz will convert a mono signal to
							//	stereo itself and call MDKWorkStereo insted.
							//	If false, MDKWork will be called in mono cases, and the output should be mono
	csex.pmi = this;
	buzzwindow = OEBSongInfo_GetBuzzWindow(pCB);
	ThisMachine = pCB->GetThisMachine();
	pCB->SetEventHandler(ThisMachine, DoubleClickMachine, (bool (CMachineInterface::*)(void *))OnDoubleClick, NULL);

	sprintf(song_title,"Untitled");
	sprintf(song_author,"");
	sprintf(song_album,"");
	sprintf(song_url,"http://");
	sprintf(song_genre,"");
	sprintf(song_other,"");
	sprintf(song_description,"<description here>");

	if (pi != NULL) {
		pi->Read(junkie,45);
		if (strncmp(junkie,"[BUZZ-MORE-SONG-INFORMATION===10][SUPRINFO10]",45) == 0) {
			pi->Read(junkie,4);
			pi->Read(junkie2);
			pi->Read(song_title,255);
			pi->Read(junkie,4);
			pi->Read(junkie2);
			pi->Read(song_author,255);
			pi->Read(junkie,4);
			pi->Read(junkie2);
			pi->Read(song_album,255);
			pi->Read(junkie,4);
			pi->Read(junkie2);
			pi->Read(song_url,255);
			pi->Read(junkie,4);
			pi->Read(junkie2);
			pi->Read(song_genre,255);
			pi->Read(junkie,4);
			pi->Read(junkie2);
			pi->Read(song_other,255);
			pi->Read(junkie,4);
			pi->Read(junkie2);
			pi->Read(song_description,4096);
			pi->Read(junkie,10);
		} else {
			MessageBox(buzzwindow,"This is a unknown SongInfo format, you might need to upgrade to extract this SongInfo data.\nNOTE: Saving this song might erase the data that was loaded in this SongInfo machine.","CyanPhase SongInfo",MB_OK);
			while (true) {
				pi->Read(junkie,1);
				if (strncmp(junkie,"[",1) == 0) {
					pi->Read(junkie,9);
					if (strncmp(junkie,"INFOENDS]",9) == 0) {
						break;
					}
				}
			}
		}
	};
	OEBSongInfo_Load(&csex);
}

void mi::MDKSave(CMachineDataOutput * const po) {
	po->Write("[BUZZ-MORE-SONG-INFORMATION===10][SUPRINFO10]",45);
	po->Write("TITL",4); po->Write((int)(255));
	po->Write(song_title,255);
	po->Write("AUTH",4); po->Write((int)(255));
	po->Write(song_author,255);
	po->Write("ALBM",4); po->Write((int)(255));
	po->Write(song_album,255);
	po->Write("URL ",4); po->Write((int)(255));
	po->Write(song_url,255);
	po->Write("GNRE",4); po->Write((int)(255));
	po->Write(song_genre,255);
	po->Write("OTHR",4); po->Write((int)(255));
	po->Write(song_other,255);
	po->Write("DESC",4); po->Write((int)(4096));
	po->Write(song_description,4096);
	po->Write("[INFOENDS]",10);
}
void mi::Tick() { }
bool mi::MDKWork(float *psamples, int numsamples, int const mode) { return false; }
bool mi::MDKWorkStereo(float *psamples, int numsamples, int const mode) { return false; }

BOOL WINAPI DllMain ( HANDLE hModule, DWORD fwdreason, LPVOID lpReserved ) {
	switch (fwdreason) {
	case DLL_PROCESS_ATTACH: {
		dllInstance = (HINSTANCE) hModule;
		LoadOEBForSongInfo(dllInstance);
		break;
	}
	case DLL_THREAD_ATTACH: break;
	case DLL_THREAD_DETACH: break;
	case DLL_PROCESS_DETACH: break;
	}
	return TRUE;
}

BOOL APIENTRY SongInfoDialog(HWND hDlg, UINT uMsg, WPARAM wParam, LPARAM lParam) {

	switch(uMsg) {
	case WM_INITDIALOG:
	{
		SetDlgItemText(hDlg,IDC_SONGTITLE,g_mi->song_title);
		SetDlgItemText(hDlg,IDC_SONGAUTHOR,g_mi->song_author);
		SetDlgItemText(hDlg,IDC_SONGALBUM,g_mi->song_album);
		SetDlgItemText(hDlg,IDC_SONGURL,g_mi->song_url);
		SetDlgItemText(hDlg,IDC_GENRESTYLE,g_mi->song_genre);
		SetDlgItemText(hDlg,IDC_OTHERSTUFF,g_mi->song_other);
		SetDlgItemText(hDlg,IDC_SONGDESCRIPTION,g_mi->song_description);
		return 1;
	}
		break;
	case WM_SHOWWINDOW: { return 1; } break;
	case WM_CLOSE: { EndDialog (hDlg, TRUE); } break;
	case WM_COMMAND: {
		switch ( LOWORD (wParam))
		{
		case IDOK:
			GetDlgItemText(hDlg,IDC_SONGTITLE,g_mi->song_title,255);
			GetDlgItemText(hDlg,IDC_SONGAUTHOR,g_mi->song_author,255);
			GetDlgItemText(hDlg,IDC_SONGALBUM,g_mi->song_album,255);
			GetDlgItemText(hDlg,IDC_SONGURL,g_mi->song_url,255);
			GetDlgItemText(hDlg,IDC_GENRESTYLE,g_mi->song_genre,255);
			GetDlgItemText(hDlg,IDC_OTHERSTUFF,g_mi->song_other,255);
			GetDlgItemText(hDlg,IDC_SONGDESCRIPTION,g_mi->song_description,4096);
			EndDialog(hDlg, TRUE);
			return 1;
		case IDCANCEL:
			EndDialog(hDlg, TRUE);
			return 1;
		default:
			return 0;
		}
	}
		break;
	default:
		break;
	}
	return 0;
}

void csinf::OpenSIDialog() { 
	g_mi=pmi;
	DialogBox(dllInstance, MAKEINTRESOURCE (IDD_SONGINFO), pmi->buzzwindow, (DLGPROC) &SongInfoDialog);
}

void csinf::GetTags(int tag_id, char *tagdata) {
	switch (tag_id) {
	case 0: sprintf(tagdata, pmi->song_title); break;
	case 1: sprintf(tagdata, pmi->song_author); break;
	case 2: sprintf(tagdata, pmi->song_album); break;
	case 3: sprintf(tagdata, pmi->song_genre); break;
	case 4: sprintf(tagdata, pmi->song_other); break;
	case 5: sprintf(tagdata, pmi->song_description); break;
	case 6: sprintf(tagdata, ""); break;
	case 7: sprintf(tagdata, ""); break;
	case 8: sprintf(tagdata, pmi->song_url); break;
	case 9: sprintf(tagdata, pmi->song_author); break;
	case 10: sprintf(tagdata, ""); break;
	case 11: sprintf(tagdata, ""); break;
	case 12: sprintf(tagdata, pmi->song_author); break;
	case 13: sprintf(tagdata, "Overloaded Buzz"); break;
	case 14: sprintf(tagdata, pmi->song_author); break;
	default: sprintf(tagdata, "");
	}
}

void mi::Command(int const i)
{
	switch (i)
	{
	case 0:
		g_mi=this;
		DialogBox(dllInstance, MAKEINTRESOURCE (IDD_SONGINFO), buzzwindow, (DLGPROC) &SongInfoDialog);
		break;
	default:
		break;
	}
}

bool mi::OnDoubleClick(void *) {
	g_mi=this;
	DialogBox(dllInstance, MAKEINTRESOURCE (IDD_SONGINFO), buzzwindow, (DLGPROC) &SongInfoDialog);
	return true;
}

char const *mi::DescribeValue(int const param, int const value) { return NULL; }

#pragma optimize ("", on) 

DLL_EXPORTS

